$NetBSD$

--- bindings/Perl/Pilot.xs.orig	2007-11-12 17:49:54.000000000 +0000
+++ bindings/Perl/Pilot.xs
@@ -160,7 +160,7 @@ SvChar4(arg)
 
 #define pack_dbinfo(arg, var, failure) {	\
 		if (failure < 0)  {		\
-			arg = &sv_undef;	\
+			arg = &PL_sv_undef;	\
 			self->errnop = failure;	\
 		} else {			\
 			HV * i = newHV();	\
@@ -214,15 +214,15 @@ SvChar4(arg)
 		var.createDate 	= (s = hv_fetch(i, "createDate", 10, 0)) ? SvIV(*s) : 0;\
 		var.modifyDate 	= (s = hv_fetch(i, "modifyDate", 10, 0)) ? SvIV(*s) : 0;\
 		var.backupDate 	= (s = hv_fetch(i, "backupDate", 10, 0)) ? SvIV(*s) : 0;\
-		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,na) : 0)		\
-			strncpy(var.name, SvPV(*s, na), sizeof(var.name));	\
+		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,PL_na) : 0)		\
+			strncpy(var.name, SvPV(*s, PL_na), sizeof(var.name));	\
 		} else	{\
 			croak("argument is not a hash reference");		\
 		}
 
 #define pack_userinfo(arg, var, failure) {	\
 	if (failure < 0)  {			\
-		arg = &sv_undef;		\
+		arg = &PL_sv_undef;		\
 		self->errnop = failure;		\
 	} else {				\
 		HV * i = newHV();		\
@@ -246,8 +246,8 @@ SvChar4(arg)
 		var.lastSyncPC 		= (s = hv_fetch(i, "lastSyncPC",         10, 0)) ? SvIV(*s) : 0;\
 		var.lastSyncDate 	= (s = hv_fetch(i, "lastSyncDate",       12, 0)) ? SvIV(*s) : 0;\
 		var.successfulSyncDate 	= (s = hv_fetch(i, "successfulSyncDate", 18, 0)) ? SvIV(*s) : 0;\
-		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,na) : 0)\
-			strncpy(var.username, SvPV(*s, na), sizeof(var.username));\
+		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,PL_na) : 0)\
+			strncpy(var.username, SvPV(*s, PL_na), sizeof(var.username));\
 		} else	{\
 			croak("argument is not a hash reference");\
 		}
@@ -287,7 +287,7 @@ SvChar4(arg)
 	    	}\
 	} else {\
 		self->errnop = result;\
-		PUSHs(&sv_undef);\
+		PUSHs(&PL_sv_undef);\
 	}
 
 #define PackSI\
@@ -329,7 +329,7 @@ SvChar4(arg)
 	    	}\
 		} else {\
 	    	self->errnop = result;\
-	    	PUSHs(&sv_undef);\
+	    	PUSHs(&PL_sv_undef);\
 	    }
 
 #define PackRecord {\
@@ -421,7 +421,7 @@ SvChar4(arg)
 	    	}\
 		} else {\
 	    	self->errnop = result;\
-	    	PUSHs(&sv_undef);\
+	    	PUSHs(&PL_sv_undef);\
 	    }
 
 #define PackResource\
@@ -473,7 +473,7 @@ SvChar4(arg)
 	    	}\
 		} else {\
 	    	self->errnop = result;\
-	    	PUSHs(&sv_undef);\
+	    	PUSHs(&PL_sv_undef);\
 	    }
 
 #define PackPref\
@@ -536,7 +536,7 @@ SvChar4(arg)
 	    		croak("Unable to create resource");\
 		} else {\
 	    	self->errnop = result;\
-	    	PUSHs(&sv_undef);\
+	    	PUSHs(&PL_sv_undef);\
 	    }
 
 void doUnpackCategory(HV * self, struct CategoryAppInfo * c)
@@ -576,7 +576,7 @@ void doPackCategory(HV * self, struct Ca
 	
     if ((s = hv_fetch(self, "categoryName", 12, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
     	for (i=0;i<16;i++)
-    		strncpy(c->name[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
+    		strncpy(c->name[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,PL_na) : "", 16);
 	else
 		for (i=0;i<16;i++)
 			strcpy(c->name[i], "");
@@ -602,7 +602,7 @@ void doPackCategory(HV * self, struct Ca
 int SvList(SV * arg, char **list)
 {
 	int i;
-	char * str = SvPV(arg, na);
+	char * str = SvPV(arg, PL_na);
 	for (i=0;list[i];i++)
 		if (strcasecmp(list[i], str)==0)
 			return i;
@@ -781,11 +781,11 @@ Pack(record)
 		    croak("Invalid advance unit %d encountered", u);
 		}
 	    } else {
-	    	if (strEQ(SvPV(*s, na), "minutes"))
+	    	if (strEQ(SvPV(*s, PL_na), "minutes"))
 		    u = 0;
-	    	else if (strEQ(SvPV(*s, na), "hours"))
+	    	else if (strEQ(SvPV(*s, PL_na), "hours"))
 		    u = 1;
-	    	else if (strEQ(SvPV(*s, na), "days"))
+	    	else if (strEQ(SvPV(*s, PL_na), "days"))
 		    u = 2;
 	    	else
 		    croak("Invalid advance unit %d encountered", u);
@@ -850,10 +850,10 @@ Pack(record)
 		}
     }    	
 
-    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,na) : 0;
+    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,PL_na) : 0;
     if (!a.description)
         croak("appointments must contain a description");
-    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,na) : 0;
+    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,PL_na) : 0;
 
     if (pack_Appointment(&a, &pibuf, datebook_v1) < 0) {
 	croak("pack_Appointment failed");
@@ -897,7 +897,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_AppointmentAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_AppointmentAppInfo(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 		doUnpackCategory(ret, &a.category);
 	
@@ -1023,8 +1023,8 @@ Pack(record)
     	a.indefinite = 1;
     }
     
-    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,na) : 0;
-    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,na) : 0;
+    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,PL_na) : 0;
+    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,PL_na) : 0;
 
     if (pack_ToDo(&a, &pibuf, todo_v1) < 0) {
 	croak("pack_ToDo failed");
@@ -1065,7 +1065,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_ToDoAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_ToDoAppInfo(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    doUnpackCategory(ret, &a.category);
 
@@ -1160,7 +1160,7 @@ Unpack(record)
 	hv_store(ret, "entry", 5, newRV_noinc((SV*)e), 0);
 	
 	for (i=0;i<19;i++) {
-	    av_push(e, a.entry[i] ? newSVpv(a.entry[i],0) : &sv_undef);
+	    av_push(e, a.entry[i] ? newSVpv(a.entry[i],0) : &PL_sv_undef);
 	}
 	    
 	hv_store(ret, "showPhone", 9, newSViv(a.showPhone), 0);
@@ -1200,7 +1200,7 @@ Pack(record)
 
     if ((s = hv_fetch(h, "entry", 5, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
     	for (i=0;i<19;i++)
-    		a.entry[i] = ((s=av_fetch(av, i, 0)) && SvOK(*s)) ? SvPV(*s,na) : 0;
+    		a.entry[i] = ((s=av_fetch(av, i, 0)) && SvOK(*s)) ? SvPV(*s,PL_na) : 0;
 	else
 		for (i=0;i<19;i++)
 			a.entry[i] = 0;
@@ -1249,7 +1249,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_AddressAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_AddressAppInfo(&a, (CPTR)SvPV(record, PL_na), len)>0) {
     
 	    doUnpackCategory(ret, &a.category);
 	    
@@ -1309,13 +1309,13 @@ PackAppBlock(record)
     a.sortByCompany = (s = hv_fetch(h, "sortByCompany", 13, 0)) ? SvIV(*s) : 0;
 
     if ((s = hv_fetch(h, "label", 5, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
-    	for (i=0;i<22;i++) strncpy(a.labels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
+    	for (i=0;i<22;i++) strncpy(a.labels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,PL_na) : "", 16);
 	else
 		for (i=0;i<22;i++) a.labels[i][0] = 0;
 	for (i=0;i<22;i++) a.labels[i][15] = 0;
 
     if ((s = hv_fetch(h, "phoneLabel", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
-    	for (i=0;i<8;i++) strncpy(a.phoneLabels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
+    	for (i=0;i<8;i++) strncpy(a.phoneLabels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,PL_na) : "", 16);
 	else
 		for (i=0;i<8;i++) a.phoneLabels[i][0] = 0;
 	for (i=0;i<8;i++) a.phoneLabels[i][15] = 0;
@@ -1396,7 +1396,7 @@ Pack(record)
     else {
     
     if ((s = hv_fetch(h, "text", 4, 0)))
-	    a.text = SvPV(*s,na);
+	    a.text = SvPV(*s,PL_na);
 	else
 		a.text = 0;
     
@@ -1438,7 +1438,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_MemoAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_MemoAppInfo(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    doUnpackCategory(ret, &a.category);
 
@@ -1510,7 +1510,7 @@ Unpack(record)
     
     SvPV(record,len);
     if (len > 0) { /* len == 0 if deleted flag is set */
-	if (unpack_Expense(&e, (CPTR)SvPV(record, na), len)>0) {
+	if (unpack_Expense(&e, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    hv_store(ret, "date", 4, newRV_noinc((SV*)tmtoav(&e.date)), 0);
 	    hv_store(ret, "type", 4, newSVlist(e.type,ExpenseTypeNames),0);
@@ -1570,15 +1570,15 @@ Pack(record)
     	avtotm((AV*)SvRV(*s), &e.date);
     else
     	croak("expense record must contain date");
-    if ((s = hv_fetch(h, "amount", 6, 0))) e.amount = SvPV(*s,na);
+    if ((s = hv_fetch(h, "amount", 6, 0))) e.amount = SvPV(*s,PL_na);
 	else e.amount = 0;
-    if ((s = hv_fetch(h, "vendor", 6, 0))) e.vendor = SvPV(*s,na);
+    if ((s = hv_fetch(h, "vendor", 6, 0))) e.vendor = SvPV(*s,PL_na);
 	else e.vendor = 0;
-    if ((s = hv_fetch(h, "city", 4, 0))) e.city = SvPV(*s,na);
+    if ((s = hv_fetch(h, "city", 4, 0))) e.city = SvPV(*s,PL_na);
 	else e.city = 0;
-    if ((s = hv_fetch(h, "attendess", 9, 0))) e.attendees = SvPV(*s,na);
+    if ((s = hv_fetch(h, "attendess", 9, 0))) e.attendees = SvPV(*s,PL_na);
 	else e.attendees = 0;
-    if ((s = hv_fetch(h, "note", 4, 0))) e.note = SvPV(*s,na);
+    if ((s = hv_fetch(h, "note", 4, 0))) e.note = SvPV(*s,PL_na);
 	else e.note = 0;
     
     len = pack_Expense(&e, mybuf, 0xffff);
@@ -1619,7 +1619,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_ExpenseAppInfo(&e, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_ExpenseAppInfo(&e, (CPTR)SvPV(record, PL_na), len)>0) {
 
 		hv_store(ret, "sortOrder", 9, newSVlist(e.sortOrder,ExpenseSortNames),0);
 		a = newAV();
@@ -1662,15 +1662,15 @@ PackAppBlock(record)
 			HV * hv;
 			if ((s=av_fetch(av, i, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(hv=(HV*)SvRV(*s))==SVt_PVHV)) {
 				if (s = hv_fetch(hv, "name", 4, 0)) {
-					strncpy(e.currencies[i].name, SvPV(*s, na), 16);
+					strncpy(e.currencies[i].name, SvPV(*s, PL_na), 16);
 					e.currencies[i].name[15] = 0;
 				}
 				if (s = hv_fetch(hv, "symbol", 6, 0)) {
-					strncpy(e.currencies[i].symbol, SvPV(*s, na), 4);
+					strncpy(e.currencies[i].symbol, SvPV(*s, PL_na), 4);
 					e.currencies[i].symbol[3] = 0;
 				}
 				if (s = hv_fetch(hv, "rate", 4, 0)) {
-					strncpy(e.currencies[i].rate, SvPV(*s, na), 8);
+					strncpy(e.currencies[i].rate, SvPV(*s, PL_na), 8);
 					e.currencies[i].rate[7] = 0;
 				}
 			}
@@ -1718,7 +1718,7 @@ UnpackPref(record)
     }
     
     SvPV(record,len);
-    if (unpack_ExpensePref(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_ExpensePref(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    hv_store(ret, "unitOfDistance", 14, newSVlist(a.unitOfDistance, ExpenseDistanceNames), 0);
 	    hv_store(ret, "currentCategory", 15, newSViv(a.currentCategory), 0);
@@ -1811,7 +1811,7 @@ Unpack(record)
     
     SvPV(record,len);
     if (len > 0) { /* len == 0 if deleted flag is set */
-	if (unpack_Mail(&a, (CPTR)SvPV(record, na), len)>0) {
+	if (unpack_Mail(&a, (CPTR)SvPV(record, PL_na), len)>0) {
     
 	    if (a.subject) hv_store(ret, "subject", 7, newSVpv(a.subject,0), 0);
 	    if (a.from) hv_store(ret, "from", 4, newSVpv(a.from,0), 0);
@@ -1858,14 +1858,14 @@ Pack(record)
     }
     else {
     
-    a.subject = (s = hv_fetch(h, "subject", 7, 0)) ? SvPV(*s,na) : 0;
-    a.from = (s = hv_fetch(h, "from", 4, 0)) ? SvPV(*s,na) : 0;
-    a.to = (s = hv_fetch(h, "to", 2, 0)) ? SvPV(*s,na) : 0;
-    a.cc = (s = hv_fetch(h, "cc", 2, 0)) ? SvPV(*s,na) : 0;
-    a.bcc = (s = hv_fetch(h, "bcc", 3, 0)) ? SvPV(*s,na) : 0;
-    a.replyTo = (s = hv_fetch(h, "replyTo", 7, 0)) ? SvPV(*s,na) : 0;
-    a.sentTo = (s = hv_fetch(h, "sentTo", 6, 0)) ? SvPV(*s,na) : 0;
-    a.body = (s = hv_fetch(h, "body", 4, 0)) ? SvPV(*s,na) : 0;
+    a.subject = (s = hv_fetch(h, "subject", 7, 0)) ? SvPV(*s,PL_na) : 0;
+    a.from = (s = hv_fetch(h, "from", 4, 0)) ? SvPV(*s,PL_na) : 0;
+    a.to = (s = hv_fetch(h, "to", 2, 0)) ? SvPV(*s,PL_na) : 0;
+    a.cc = (s = hv_fetch(h, "cc", 2, 0)) ? SvPV(*s,PL_na) : 0;
+    a.bcc = (s = hv_fetch(h, "bcc", 3, 0)) ? SvPV(*s,PL_na) : 0;
+    a.replyTo = (s = hv_fetch(h, "replyTo", 7, 0)) ? SvPV(*s,PL_na) : 0;
+    a.sentTo = (s = hv_fetch(h, "sentTo", 6, 0)) ? SvPV(*s,PL_na) : 0;
+    a.body = (s = hv_fetch(h, "body", 4, 0)) ? SvPV(*s,PL_na) : 0;
     
     a.read = (s = hv_fetch(h, "read", 4, 0)) ? SvIV(*s) : 0;
     a.signature = (s = hv_fetch(h, "signature", 9, 0)) ? SvIV(*s) : 0;
@@ -1913,7 +1913,7 @@ UnpackAppBlock(record)
     }
     
     SvPV(record,len);
-    if (unpack_MailAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_MailAppInfo(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    doUnpackCategory(ret, &a.category);
 
@@ -1989,7 +1989,7 @@ UnpackSyncPref(record)
     }
     
     SvPV(record,len);
-    if (unpack_MailSyncPref(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_MailSyncPref(&a, (CPTR)SvPV(record, PL_na), len)>0) {
 
 	    hv_store(ret, "syncType", 8, newSVlist(a.syncType, MailSyncTypeNames), 0);
 	    hv_store(ret, "getHigh", 7, newSViv(a.getHigh), 0);
@@ -2033,9 +2033,9 @@ PackSyncPref(record, id)
 	a.getContaining = (s=hv_fetch(h,"getContaining",13,0)) ? SvIV(*s) : 0;
 	a.truncate = (s=hv_fetch(h,"truncate",8,0)) ? SvIV(*s) : 0;
 
-	a.filterTo = (s=hv_fetch(h,"filterTo",8,0)) ? SvPV(*s,na) : 0;
-	a.filterFrom = (s=hv_fetch(h,"filterFrom",10,0)) ? SvPV(*s,na) : 0;
-	a.filterSubject = (s=hv_fetch(h,"filterSubject",13,0)) ? SvPV(*s,na) : 0;
+	a.filterTo = (s=hv_fetch(h,"filterTo",8,0)) ? SvPV(*s,PL_na) : 0;
+	a.filterFrom = (s=hv_fetch(h,"filterFrom",10,0)) ? SvPV(*s,PL_na) : 0;
+	a.filterSubject = (s=hv_fetch(h,"filterSubject",13,0)) ? SvPV(*s,PL_na) : 0;
 
     len = pack_MailSyncPref(&a, mybuf, 0xffff);
 
@@ -2073,7 +2073,7 @@ UnpackSignaturePref(record)
     }
     
     SvPV(record,len);
-    if (unpack_MailSignaturePref(&a, (CPTR)SvPV(record, na), len)>0) {
+    if (unpack_MailSignaturePref(&a, (CPTR)SvPV(record, PL_na), len)>0) {
   
 	    if (a.signature)  
 		    hv_store(ret, "signature", 9, newSVpv(a.signature, 0), 0);
@@ -2099,7 +2099,7 @@ PackSignaturePref(record, id)
     	RETVAL = record;
     else {
 
-	a.signature = (s=hv_fetch(h,"signature",9,0)) ? SvPV(*s,na) : 0;
+	a.signature = (s=hv_fetch(h,"signature",9,0)) ? SvPV(*s,PL_na) : 0;
 
     len = pack_MailSignaturePref(&a, mybuf, 0xffff);
 
@@ -2129,7 +2129,7 @@ write(socket, msg)
 	{
 	    STRLEN len;
 	    SvPV(msg, len);
-		RETVAL = pi_write(socket,SvPV(msg,na),len);
+		RETVAL = pi_write(socket,SvPV(msg,PL_na),len);
 	}
 
 SV *
@@ -2146,7 +2146,7 @@ read(socket, len)
 	    if (result >=0) 
 	    	RETVAL = newSVpvn((char *) pibuf.data, result);
 	    else
-	    	RETVAL = &sv_undef;
+	    	RETVAL = &PL_sv_undef;
 	}
 	OUTPUT:
 	RETVAL
@@ -2282,7 +2282,7 @@ class(self, name=0)
 				croak("DBClasses doesn't exist");
 			if (SvOK(name)) {
 				(void)SvPV(name,len);
-				s = hv_fetch(h, SvPV(name,na), len, 0);
+				s = hv_fetch(h, SvPV(name,PL_na), len, 0);
 			}
 			if (!s)
 				s = hv_fetch(h, "", 0, 0);
@@ -2577,7 +2577,7 @@ getRecords(self)
 	{
 		int result = dlp_ReadOpenDBInfo(self->socket, self->handle, &RETVAL);
 		if (result < 0) {
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 			self->errnop = result;
 		}
 	}
@@ -2745,7 +2745,7 @@ setResource(self, data)
 		result = dlp_WriteResource(self->socket, self->handle, type, id, c, len);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else
 			RETVAL = newSViv(result);
 	}
@@ -2798,7 +2798,7 @@ getPref(self, id=0, backup=1)
 		    r = dlp_CloseDB(self->socket, self->handle);
 	    result = dlp_ReadAppPreference(self->socket, creator, id, backup, 0xFFFF, mybuf, &len, &version);
 	    if (pi_version(self->socket)< 0x101)
-		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,na), &self->handle);
+		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,PL_na), &self->handle);
 	    ReturnReadPref(mybuf, len);
 	}
 
@@ -2822,10 +2822,10 @@ setPref(self, data)
 	    	r = dlp_CloseDB(self->socket, self->handle);
 	    result = dlp_WriteAppPreference(self->socket, creator, id, backup, version, buf, len);
     	if (pi_version(self->socket)< 0x101)
-		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,na), &self->handle);
+		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,PL_na), &self->handle);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			RETVAL = newSViv(result);
 		}
@@ -2861,7 +2861,7 @@ setPrefRaw(self, data, number, version, 
 	    result = dlp_WriteAppPreference(self->socket, creator, number, backup, version, buf, len);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			RETVAL = newSViv(result);
 		}
@@ -2904,7 +2904,7 @@ getTime(self)
 		int result = dlp_GetSysDateTime(self->socket, &t);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else
 			RETVAL = newSViv(t);
 	}
@@ -2929,7 +2929,7 @@ getSysInfo(self)
 		int result = dlp_ReadSysInfo(self->socket, &si);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			HV * i = newHV();
 			hv_store(i, "romVersion", 10, newSViv(si.romVersion), 0);\
@@ -2951,7 +2951,7 @@ getCardInfo(self, cardno=0)
 		int result = dlp_ReadStorageInfo(self->socket, cardno, &c);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			HV * i = newHV();
 			hv_store(i, "card", 6, newSViv(c.card), 0);\
@@ -3037,7 +3037,7 @@ newPref(self, creator, id=0, version=0, 
 			croak("Default PrefClass not defined");			
    		PUSHMARK(sp);										
    		XPUSHs(newSVsv(*s));								
-   		XPUSHs(&sv_undef);									
+   		XPUSHs(&PL_sv_undef);									
     	XPUSHs(sv_2mortal(newSVChar4(creator)));			
     	if (id)
 	    	XPUSHs(id);					
@@ -3107,7 +3107,7 @@ open(self, name, mode=0, cardno=0)
 		result = dlp_OpenDB(self->socket, cardno, nummode, name, &handle);
 		if (result<0) {
 			self->errnop = result;
-			RETVAL = &sv_undef;
+			RETVAL = &PL_sv_undef;
 		} else {
 			int type;
 			PDA__Pilot__DLP__DB * x = malloc(sizeof(PDA__Pilot__DLP__DB));
@@ -3156,7 +3156,7 @@ create(self, name, creator, type, flags,
 		int result = dlp_CreateDB(self->socket, creator, type, cardno, flags, version, name, &handle);
 		if (result<0) {
 			self->errnop = result;
-			RETVAL = &sv_undef;
+			RETVAL = &PL_sv_undef;
 		} else {
 			PDA__Pilot__DLP__DB * x = malloc(sizeof(PDA__Pilot__DLP__DB));
 			SV * sv = newSViv((IV)(void*)x);
@@ -3224,7 +3224,7 @@ setPref(self, data)
 	    result = dlp_WriteAppPreference(self->socket, creator, id, backup, version, buf, len);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			RETVAL = newSViv(result);
 		}
@@ -3248,7 +3248,7 @@ setPrefRaw(self, data, creator, number, 
 	    result = dlp_WriteAppPreference(self->socket, creator, number, backup, version, buf, len);
 		if (result < 0) {
 			self->errnop = result;
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 		} else {
 			RETVAL = newSViv(result);
 		}
@@ -3350,7 +3350,7 @@ findDBInfo(self, start, name, creator, t
 		else
 			t = 0;
 		result = dlp_FindDBInfo(self->socket, cardno, start, 
-			SvOK(name) ? SvPV(name,na) : 0,
+			SvOK(name) ? SvPV(name,PL_na) : 0,
 			t, c, &info);
 		pack_dbinfo(RETVAL, info, result);
 	}
@@ -3367,7 +3367,7 @@ getFeature(self, creator, number)
 		unsigned long f;
 		int result;
 		if ((result = dlp_ReadFeature(self->socket, creator, number, &f))<0) {
-			RETVAL = newSVsv(&sv_undef);
+			RETVAL = newSVsv(&PL_sv_undef);
 			self->errnop = result;
 		} else {
 			RETVAL = newSViv(f);
@@ -3397,7 +3397,7 @@ getROMToken(self,token)
 	}
 
 void
-callApplication(self, creator, type, action, data=&sv_undef)
+callApplication(self, creator, type, action, data=&PL_sv_undef)
 	PDA::Pilot::DLP *self
 	Char4	creator
 	Char4	type
@@ -3410,7 +3410,7 @@ callApplication(self, creator, type, act
 		int result;
 		(void)SvPV(data,len);
 		result = dlp_CallApplication(self->socket, creator, 
-				    type, action, len, SvPV(data,na),
+				    type, action, len, SvPV(data,PL_na),
 		                    &retcode, &pibuf);
 		EXTEND(sp, 2);
 		if (result >= 0) {
@@ -3419,7 +3419,7 @@ callApplication(self, creator, type, act
 				PUSHs(sv_2mortal(newSViv(retcode)));
 			}
 		} else
-			PUSHs(&sv_undef);
+			PUSHs(&PL_sv_undef);
 	}
 
 int
@@ -3530,7 +3530,7 @@ class(self, name=0)
 				croak("DBClasses doesn't exist");
 			if (SvOK(name)) {
 				(void)SvPV(name, len);
-				s = hv_fetch(h, SvPV(name, na), len, 0);
+				s = hv_fetch(h, SvPV(name, PL_na), len, 0);
 			}
 			if (!s)
 				s = hv_fetch(h, "", 0, 0);
