$NetBSD$

Fix for CVE-2012-1150 taken from here:

http://hg.python.org/cpython/rev/6b7704fe1be1

--- Objects/unicodeobject.c.orig	2010-08-01 22:48:47.000000000 +0100
+++ Objects/unicodeobject.c	2012-03-25 09:51:50.000000000 +0100
@@ -6695,11 +6695,21 @@
     if (self->hash != -1)
         return self->hash;
     len = PyUnicode_GET_SIZE(self);
+    /*
+      We make the hash of the empty string be 0, rather than using
+      (prefix ^ suffix), since this slightly obfuscates the hash secret
+    */
+    if (len == 0) {
+        self->hash = 0;
+        return 0;
+    }
     p = PyUnicode_AS_UNICODE(self);
-    x = *p << 7;
+    x = _Py_HashSecret.prefix;
+    x ^= *p << 7;
     while (--len >= 0)
         x = (1000003*x) ^ *p++;
     x ^= PyUnicode_GET_SIZE(self);
+    x ^= _Py_HashSecret.suffix;
     if (x == -1)
         x = -2;
     self->hash = x;
